<?php
// Broadcast sender (uses DB and BOT_TOKEN from config.php)
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/class.php';

$connect = db_connect();

function tg_call($method, $params = []) {
    $url = "https://api.telegram.org/bot" . BOT_TOKEN . "/" . $method;
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
    curl_setopt($ch, CURLOPT_TIMEOUT, 20);
    if (defined('DISABLE_SSL_VERIFY') && DISABLE_SSL_VERIFY) {
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    }
    $res = curl_exec($ch);
    if ($res === false) {
        error_log('Broadcast cURL error: ' . curl_error($ch));
        curl_close($ch);
        return null;
    }
    curl_close($ch);
    return json_decode($res, true);
}

$send = $connect->query("SELECT * FROM `send` LIMIT 1");
if (!$send || $send->num_rows === 0) {
    echo "There is no message to send\n";
    exit;
}

$row = $send->fetch_assoc();
$admin = $row['from'];
$offset = (int)$row['user'];
$text = urldecode($row['text'] ?? '');
$photo = $row['photo'] ?? '';

$users = $connect->query("SELECT id FROM `user` ORDER BY id ASC LIMIT 100 OFFSET $offset");
while ($users && $u = $users->fetch_assoc()) {
    $id = (int)$u['id'];
    if (strlen($photo) > 20) {
        tg_call('sendPhoto', [
            'chat_id' => $id,
            'photo' => $photo,
            'caption' => $text,
            'disable_web_page_preview' => true,
            'parse_mode' => 'html'
        ]);
    } else {
        tg_call('sendMessage', [
            'chat_id' => $id,
            'text' => $text,
            'disable_web_page_preview' => true,
            'parse_mode' => 'html'
        ]);
    }
    $connect->query("UPDATE `send` SET `user` = `user` + 1");
}

$total = $connect->query("SELECT COUNT(*) c FROM `user`")->fetch_assoc()['c'] ?? 0;
if ($offset + 101 > (int)$total) {
    tg_call('sendMessage', [
        'chat_id' => $admin,
        'text' => "ارسال پیام برای " . number_format((int)$total) . " کاربر به پایان رسید."
    ]);
    $connect->query("DELETE FROM `send`");
}

