<?php
ob_start();
require_once __DIR__ . '/config.php';

// --- CONFIG & INCLUDES ---
define('API_KEY', BOT_TOKEN);
$connect = db_connect();
// --- CORE FUNCTIONS ---
if (!function_exists('bot')) {
function bot($method, $datas = []) {
    $url = "https://api.telegram.org/bot" . API_KEY . "/" . $method;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $datas);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
    curl_setopt($ch, CURLOPT_TIMEOUT, 20);
    if (defined('DISABLE_SSL_VERIFY') && DISABLE_SSL_VERIFY) {
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    }
    $res = curl_exec($ch);
    if ($res === false) {
        error_log('Telegram cURL error: ' . curl_error($ch));
        curl_close($ch);
        return null;
    }
    curl_close($ch);
    return json_decode($res, true);
}
}

function sendMessage($chatid, $text, $keyboard = null, $pars = 'html') {
    return bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => $text,
        'reply_markup' => $keyboard,
        'parse_mode' => $pars,
        'disable_web_page_preview' => true
    ]);
}

function deleteService($serviceId, $connect) {
    $stmt = $connect->prepare("SELECT * FROM services WHERE id = ? LIMIT 1");
    $stmt->bind_param("s", $serviceId);
    $stmt->execute();
    $service_res = $stmt->get_result();
    if ($service_res->num_rows == 0) { $stmt->close(); return false; }
    $service = $service_res->fetch_assoc();
    $stmt->close();

    $stmt_server = $connect->prepare("SELECT * FROM servers WHERE name = ? AND status = 'on' LIMIT 1");
    $stmt_server->bind_param("s", $service['svname']);
    $stmt_server->execute();
    $server_res = $stmt_server->get_result();
    if ($server_res->num_rows == 0) { $stmt_server->close(); return false; }
    $server = $server_res->fetch_assoc();
    $stmt_server->close();

    // Include necessary files only once
    if (!function_exists('loginPanel')) include_once("class.php");
    if (!function_exists('DeleteClient') && file_exists("api/sanaei.php")) include_once("api/sanaei.php");

    if ($server['type'] == 'marzban') {
        $token = loginPanel($server['link'], $server['username'], $server['password'])['access_token'];
        if($token) deleteUser($service['name'], $token, $server['link']);
    } elseif ($server['type'] == 'sanaei' && function_exists('DeleteClient')) {
        login($server['link'], $server['username'], $server['password']);
        DeleteClient($service['uuid'], $server['inbound_copy'], $server['link']);
    }

    $stmt_delete = $connect->prepare("DELETE FROM services WHERE id = ?");
    $stmt_delete->bind_param("s", $serviceId);
    $stmt_delete->execute();
    $stmt_delete->close();
    return true;
}

// --- MAIN CRON LOGIC ---
$get = mysqli_query($connect, "SELECT * FROM services");
$res = [];
if ($get) {
    while ($row = $get->fetch_assoc()) {
        $res[] = $row;
    }
}

$now = time();

foreach ($res as $service) {
    $id = $service['id'];
    $name = $service['name'];
    $display_name = $service['display'];
    $expire = $service['expire'];
    $tdays = $service['tdays'];
    $delet = $service['delet'];
    $owner = $service['owner'];
    $svname = $service['svname'];
    $size = round($service['size'], 2);
    $volume_notified = $service['volume_notified'] ?? '0';

    $stmt_server = $connect->prepare("SELECT * FROM servers WHERE name = ? AND status = 'on' LIMIT 1");
    $stmt_server->bind_param("s", $svname);
    $stmt_server->execute();
    $server_res = $stmt_server->get_result();
    if ($server_res->num_rows == 0) {
        $stmt_server->close();
        continue; // Skip if server not found or is off
    }
    $server = $server_res->fetch_assoc();
    $stmt_server->close();
    
    $type = $server['type'];
    $link = $server['link'];
    $username = $server['username'] ?: 'ندارد';
    $password = $server['password'] ?: 'ندارد';

    // Get traffic usage
    $gigabytes = 0;
    $status = "🔴 غیرفعال";
    if (!function_exists('loginPanel')) include_once("class.php");
    if ($type == "marzban") {
        $token = loginPanel($link, $username, $password)['access_token'];
        if($token){
            $url = "$link/api/user/$name";
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPGET, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, ['Accept: application/json', 'Authorization: Bearer ' . $token]);
            $response = curl_exec($ch);
            curl_close($ch);
            $json = json_decode($response, true);
            if(isset($json['used_traffic'])){
                $bytes = $json['used_traffic'];
                $gigabytes = round($bytes / 1073741824, 2);
                $status = ($json['status'] == "active") ? "🟢 فعال" : "🔴 غیرفعال";
            }
        }
    } elseif ($type == 'sanaei') {
        if (!function_exists('getClientTraffic') && file_exists("api/sanaei.php")) include_once("api/sanaei.php");
        if(function_exists('getClientTraffic')){
            login($link, $username, $password);
            $json_response = getClientTraffic($link, $name);
            if($json_response){
                $json = json_decode($json_response, true)['obj'];
                if(isset($json['up'], $json['down'])){
                    $bytes = $json['up'] + $json['down'];
                    $gigabytes = round($bytes / 1073741824, 2);
                    $status = ($json['enable'] == true) ? "🟢 فعال" : "🔴 غیرفعال";
                }
            }
        }
    }
    
    $remain = $size - $gigabytes;
    $used_percentage = ($size > 0) ? ($gigabytes / $size) * 100 : 0;

    $key_extend = json_encode(['inline_keyboard' => [[['text' => "✨ بزن بریم تمدیدش کنیم!", "callback_data" => "ex-$id"]],]]);
    $stmt_update = $connect->prepare("UPDATE services SET volume_notified=? WHERE id=?");
    
    if ($used_percentage >= 70 && $volume_notified < '70' && $status == "🟢 فعال") {
        $new_notified = '70';
        $stmt_update->bind_param("ss", $new_notified, $id);
        $stmt_update->execute();
        sendMessage($owner, "📊 کاربر گرامی، 70% از حجم سرویس شما با نام $display_name مصرف شده است. حجم باقی‌مانده: $remain گیگابایت", $key_extend);
    }
    if ($used_percentage >= 80 && $volume_notified < '80' && $status == "🟢 فعال") {
        $new_notified = '80';
        $stmt_update->bind_param("ss", $new_notified, $id);
        $stmt_update->execute();
        sendMessage($owner, "⚠️ هشدار: 80% از حجم سرویس $display_name مصرف شده است. لطفاً برای تمدید اقدام کنید. حجم باقی‌مانده: $remain گیگابایت", $key_extend);
    }
    if ($used_percentage >= 90 && $volume_notified < '90') {
        $new_notified = '90';
        $stmt_update->bind_param("ss", $new_notified, $id);
        $stmt_update->execute();
        sendMessage($owner, "❗️ توجه: 90% از حجم سرویس $display_name مصرف شده است. حجم باقی‌مانده: $remain گیگابایت. به‌زودی سرویس غیرفعال خواهد شد!", $key_extend);
    }
    if ($used_percentage >= 100 && $volume_notified < '100') {
        $stmt_del = $connect->prepare("UPDATE services SET volume_notified='100', delet=? WHERE id=?");
        $delete_time = strtotime("+12 hours");
        $stmt_del->bind_param("is", $delete_time, $id);
        $stmt_del->execute();
        $stmt_del->close();
        sendMessage($owner, "⛔️ حجم سرویس شما با نام $display_name به اتمام رسیده و تا 12 ساعت دیگر حذف خواهد شد. لطفاً جهت جلوگیری از حذف، آن را تمدید کنید.", $key_extend);
    }
    $stmt_update->close();

    if (!function_exists('gregorian_to_jalali')) include_once('jdf.php');
    $Y = date('Y', $expire); $m = date('m', $expire); $d = date('d', $expire); 
    $date = gregorian_to_jalali($Y, $m, $d, '/');
    
    $days_remaining = ($expire - $now) / 86400;
    
    $stmt_tdays = $connect->prepare("UPDATE services SET tdays=? WHERE id=?");
    if ($days_remaining > 2 && $days_remaining <= 3 && $tdays != "123") {
        $new_tdays = "123";
        $stmt_tdays->bind_param("ss", $new_tdays, $id);
        $stmt_tdays->execute();
        sendMessage($owner, "❗️کاربر گرامی، سرویس شما با نام $display_name سه روز دیگر به اتمام می‌رسد.", $key_extend);
    }
    elseif ($days_remaining > 1 && $days_remaining <= 2 && $tdays != "122") {
        $new_tdays = "122";
        $stmt_tdays->bind_param("ss", $new_tdays, $id);
        $stmt_tdays->execute();
        sendMessage($owner, "⏳ توجه: فقط دو روز تا پایان سرویس $display_name باقی‌ست.", $key_extend);
    }
    elseif ($days_remaining > 0 && $days_remaining <= 1 && $tdays != "121") {
        $new_tdays = "121";
        $stmt_tdays->bind_param("ss", $new_tdays, $id);
        $stmt_tdays->execute();
        sendMessage($owner, "⚠️ هشدار: سرویس شما با نام $display_name فردا منقضی می‌شود.", $key_extend);
    }
    $stmt_tdays->close();

    if ($now > $expire && !is_numeric($delet)) {
        $stmt_del_expire = $connect->prepare("UPDATE services SET delet=? WHERE id=?");
        $delete_time_expire = strtotime("+12 hours");
        $stmt_del_expire->bind_param("is", $delete_time_expire, $id);
        $stmt_del_expire->execute();
        $stmt_del_expire->close();
        $expired_msg = "⛔️ #توجه:\nاز منقضی شدن سرویس شما مدتی هست میگذره!\n\n🔎 اسم سرویس:\n$display_name\n\n🔋 $gigabytes گیگ روی این سرویس مصرف داشتی!\n⌛️ تاریخ انقضا: $date\n\n\n⚠️ دقت کن که:\nمیتونی این کانفیگ رو تا 12 ساعت از حالا تمدید کنی, در غیر این صورت کانفیگ پاک میشه و قابل تمدید نیست.\n\n-جهت تمدید از دکمه زیر اقدام کنید👇";
        sendMessage($owner, $expired_msg, $key_extend);
    }

    if (is_numeric($delet) && $now > $delet) {
        if (deleteService($id, $connect)) {
            sendMessage($owner, "🗑️ کاربر گرامی، سرویس شما با نام $display_name به دلیل عدم تمدید، از سرور حذف شد.");
        }
    }
}

mysqli_close($connect);
?>
