<?php
require_once __DIR__ . '/../config.php';

function http_json_request($url, $method = 'GET', $payload = null, $headers = [], $timeout = 20) {
    $ch = curl_init();
    $opts = [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => $timeout,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => strtoupper($method),
        CURLOPT_HTTPHEADER => array_merge(['accept: application/json'], $headers),
    ];
    if ($payload !== null) {
        $body = is_string($payload) ? $payload : json_encode($payload, JSON_UNESCAPED_UNICODE);
        $opts[CURLOPT_POSTFIELDS] = $body;
        $opts[CURLOPT_HTTPHEADER][] = 'content-type: application/json';
    }
    // SSL
    $opts[CURLOPT_SSL_VERIFYPEER] = !DISABLE_SSL_VERIFY;
    $opts[CURLOPT_SSL_VERIFYHOST] = DISABLE_SSL_VERIFY ? 0 : 2;

    curl_setopt_array($ch, $opts);
    $res = curl_exec($ch);
    if ($res === false) {
        $err = curl_error($ch);
        curl_close($ch);
        throw new Exception('cURL error: ' . $err);
    }
    $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    return [$code, json_decode($res, true)];
}
